<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Fax\V1;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Rest\Fax\V1\Fax\FaxMediaList;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 *
 * @property string $sid
 * @property string $accountSid
 * @property string $from
 * @property string $to
 * @property string $quality
 * @property string $mediaSid
 * @property string $mediaUrl
 * @property int $numPages
 * @property int $duration
 * @property string $status
 * @property string $direction
 * @property string $apiVersion
 * @property string $price
 * @property string $priceUnit
 * @property \DateTime $dateCreated
 * @property \DateTime $dateUpdated
 * @property array $links
 * @property string $url
 */
class FaxInstance extends InstanceResource {
    protected $_media;

    /**
     * Initialize the FaxInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, array $payload, string $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'from' => Values::array_get($payload, 'from'),
            'to' => Values::array_get($payload, 'to'),
            'quality' => Values::array_get($payload, 'quality'),
            'mediaSid' => Values::array_get($payload, 'media_sid'),
            'mediaUrl' => Values::array_get($payload, 'media_url'),
            'numPages' => Values::array_get($payload, 'num_pages'),
            'duration' => Values::array_get($payload, 'duration'),
            'status' => Values::array_get($payload, 'status'),
            'direction' => Values::array_get($payload, 'direction'),
            'apiVersion' => Values::array_get($payload, 'api_version'),
            'price' => Values::array_get($payload, 'price'),
            'priceUnit' => Values::array_get($payload, 'price_unit'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'dateUpdated' => Deserialize::dateTime(Values::array_get($payload, 'date_updated')),
            'links' => Values::array_get($payload, 'links'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return FaxContext Context for this FaxInstance
     */
    protected function proxy(): FaxContext {
        if (!$this->context) {
            $this->context = new FaxContext($this->version, $this->solution['sid']);
        }

        return $this->context;
    }

    /**
     * Fetch the FaxInstance
     *
     * @return FaxInstance Fetched FaxInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): FaxInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Delete the FaxInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->proxy()->delete();
    }

    /**
     * Access the media
     */
    protected function getMedia(): FaxMediaList {
        return $this->proxy()->media;
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Fax.V1.FaxInstance ' . \implode(' ', $context) . ']';
    }
}